#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_MMC3.h"

namespace {
uint8_t reg;

void sync (void) {
	int prgAND = reg &0x04? 0x1F: 0x0F;
	MMC3::syncWRAM(0);
	MMC3::syncPRG(prgAND, reg <<4 &~prgAND);
	MMC3::syncCHR(0x7F, reg <<7);
	MMC3::syncMirror();
}

void MAPINT writeReg (int, int, int val) {
	if (~reg &0x08) {
		reg = val;
		sync();
	}
}

BOOL MAPINT load (void) {
	MMC3::load(sync, MMC3Type::AX5202P, NULL, NULL, NULL, writeReg);
	return TRUE;
}

void MAPINT reset (RESET_TYPE resetType) {
	reg = 0;
	MMC3::reset(RESET_HARD);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	offset = MMC3::saveLoad(stateMode, offset, data);
	SAVELOAD_BYTE(stateMode, offset, data, reg);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 572;
} // namespace

MapperInfo MapperInfo_596 = {
	&mapperNum,
	_T("FC-49"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	saveLoad,
	NULL,
	NULL
};