﻿#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_MMC3.h"

namespace {
uint8_t reg;

void sync (void) {
	MMC3::syncWRAM(0);
	MMC3::syncPRG(0x3F, 0);
	for (int bank = 0; bank <8; bank++) {
		int val = MMC3::getCHRBank(bank);
		if (val &0x80)
			EMU->SetCHR_RAM1(bank, val &1);
		else
			EMU->SetCHR_ROM1(bank, val | ((reg &3) == 3? 0x00: 0x80));
	}
	MMC3::syncMirror();
}

void MAPINT writeReg (int bank, int addr, int val) {
	if (addr == 0x0AA) {
		reg = val;
		sync();
	} else
		MMC3::write(bank, addr, val);
}

int getPRGBank (int bank) {
	if (bank &2)
		return MMC3::getPRGBank(bank) &~6 | reg <<1 &6;
	else
		return MMC3::getPRGBank(bank);
}

BOOL MAPINT load (void) {
	iNES_SetSRAM();
	MMC3::load(sync, MMC3Type::AX5202P, getPRGBank, NULL, NULL, NULL);
	return TRUE;
}

void MAPINT reset (RESET_TYPE resetType) {
	reg = ROM->INES2_SubMapper == 1? 0x00: 0x03;
	MMC3::reset(RESET_HARD);
	EMU->SetCPUWriteHandler(0x9, writeReg);
}

uint16_t mapperNum = 191;
} // namespace

MapperInfo MapperInfo_191 = {
	&mapperNum,
	_T("赌神 4-in-1"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	MMC3::saveLoad,
	NULL,
	NULL
};
