#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_MMC3.h"

namespace {
uint8_t reg;

void sync (void) {
	int prgAND = reg &0x08? 0x1F: 0x0F;
	int chrAND = reg &0x08 && reg &0x20? 0xFF: 0x7F;
	MMC3::syncPRG(prgAND, reg <<4 &~prgAND);
	if (reg &0x10)
		MMC3::syncCHR_RAM(chrAND, reg <<7 &~chrAND);
	else
		MMC3::syncCHR_ROM(chrAND, reg <<7 &~chrAND);
	if (ROM->INES2_SubMapper == 1 && reg &0x08)
		MMC3::syncMirrorA17();
	else
		MMC3::syncMirror();
	MMC3::syncWRAM(0);
}

void MAPINT writeReg (int, int addr, int) {
	if (!(reg &7)) {
		reg = addr &0xFF;
		sync();
	}
}

BOOL MAPINT load (void) {
	MMC3::load(sync, MMC3Type::AX5202P, NULL, NULL, NULL, writeReg);
	return TRUE;
}

void MAPINT reset (RESET_TYPE) {
	reg = 0;
	MMC3::reset(RESET_HARD);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	offset = MMC3::saveLoad(stateMode, offset, data);
	SAVELOAD_BYTE(stateMode, offset, data, reg);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 327;
} // namespace

MapperInfo MapperInfo_327 = {
	&mapperNum,
	_T("10-24-C-A1"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	saveLoad,
	NULL,
	NULL
};
