
m_clockFreq = 0						-- クロック周波数
m_baseClock = 0						-- ベースクロック
m_breakFlag = 0						-- 停止フラグ（bit1:ブレークポイント, bit0:ステップイン・アウト実行）
m_bkpt      = -1					-- ブレークポイント（-1 時は無効）
m_regPC     = 0						-- プログラムカウンタ
m_regA      = 0						-- A レジスタ
m_regB      = 0						-- B レジスタ
m_regC      = 0						-- C フラグ
m_regClock  = 1						-- クロック数

m_mnemonic = {						-- ニーモニック
	[0]  = "ADD     A, ",
	[1]  = "MOV     A, B",
	[2]  = "IN      A",
	[3]  = "MOV     A, ",
	[4]  = "MOV     B, A",
	[5]  = "ADD     B, ",
	[6]  = "IN      B",
	[7]  = "MOV     B, ",
	[8]  = "DB      0x",
	[9]  = "OUT     B",
	[10] = "DB      0x",
	[11] = "OUT     %",
	[12] = "DB      0x",
	[13] = "DB      0x",
	[14] = "JNC     ",
	[15] = "JMP     ",
}

m_mnemonicType = {					-- ニーモニック引数種類（0:引数なし, 1:2進数(4bit), 2:10進数(4bit), 3:16進数(4bit), 4:16進数(8bit)）
	[0]  = 2,
	[1]  = 0,
	[2]  = 0,
	[3]  = 2,
	[4]  = 0,
	[5]  = 2,
	[6]  = 0,
	[7]  = 2,
	[8]  = 4,
	[9]  = 0,
	[10] = 4,
	[11] = 1,
	[12] = 4,
	[13] = 4,
	[14] = 3,
	[15] = 3,
}

m_inst = {							-- 命令処理
	-- -------------------------------- 
	--   ADD     A, Im                  
	-- -------------------------------- 
	[0] = function(opcode)
		value  = m_regA + (opcode & 15)
		m_regA = value & 15
		m_regC = value >> 4
	end,

	-- -------------------------------- 
	--   MOV     A, B                   
	-- -------------------------------- 
	[1] = function(opcode)
		m_regA = m_regB
		m_regC = 0
	end,

	-- -------------------------------- 
	--   IN      A                      
	-- -------------------------------- 
	[2] = function(opcode)
		m_regA = (vdmod_readPin(4)   ) |
		         (vdmod_readPin(5)<<1) |
		         (vdmod_readPin(6)<<2) |
		         (vdmod_readPin(7)<<3)
		m_regC = 0
	end,

	-- -------------------------------- 
	--   MOV     A, Im                  
	-- -------------------------------- 
	[3] = function(opcode)
		m_regA = opcode & 15
		m_regC = value >> 4
	end,

	-- -------------------------------- 
	--   MOV     B, A                   
	-- -------------------------------- 
	[4] = function(opcode)
		m_regB = m_regA
		m_regC = 0
	end,

	-- -------------------------------- 
	--   ADD     B, Im                  
	-- -------------------------------- 
	[5] = function(opcode)
		value  = m_regB + (opcode & 15)
		m_regB = value & 15
		m_regC = value >> 4
	end,

	-- -------------------------------- 
	--   IN      B                      
	-- -------------------------------- 
	[6] = function(opcode)
		m_regB = (vdmod_readPin(4)   ) |
		         (vdmod_readPin(5)<<1) |
		         (vdmod_readPin(6)<<2) |
		         (vdmod_readPin(7)<<3)
		m_regC = 0
	end,

	-- -------------------------------- 
	--   MOV     B, Im                  
	-- -------------------------------- 
	[7] = function(opcode)
		m_regB = opcode & 15
		m_regC = value >> 4
	end,

	-- -------------------------------- 
	--   OUT     B                      
	-- -------------------------------- 
	[9] = function(opcode)
		vdmod_writePin(0,  m_regB    &1)
		vdmod_writePin(1, (m_regB>>1)&1)
		vdmod_writePin(2, (m_regB>>2)&1)
		vdmod_writePin(3, (m_regB>>3)&1)
		m_regC = 0
	end,

	-- -------------------------------- 
	--   OUT     Im                     
	-- -------------------------------- 
	[11] = function(opcode)
		vdmod_writePin(0,  opcode    &1)
		vdmod_writePin(1, (opcode>>1)&1)
		vdmod_writePin(2, (opcode>>2)&1)
		vdmod_writePin(3, (opcode>>3)&1)
		m_regC = 0
	end,

	-- -------------------------------- 
	--   JNC     Im                     
	-- -------------------------------- 
	[14] = function(opcode)
		if m_regC == 0 then
			m_regPC = opcode & 15
		else
			m_regC = 0
		end
	end,

	-- -------------------------------- 
	--   JMP     Im                     
	-- -------------------------------- 
	[15] = function(opcode)
		m_regPC = opcode & 15
		m_regC  = 0
	end,

	-- -------------------------------- 
	--   未定義命令                     
	-- -------------------------------- 
	[8]  = function(opcode) vdmod_stopClockGen(3) end,
	[10] = function(opcode) vdmod_stopClockGen(3) end,
	[12] = function(opcode) vdmod_stopClockGen(3) end,
	[13] = function(opcode) vdmod_stopClockGen(3) end,
}


vdmod_setCpuCtrlInfo(1, 0, 15)
vdmod_setMemoryInfo("memory", 0, 15)

vdmod_addRegister("PC",    4)
vdmod_addRegister("A",     4)
vdmod_addRegister("B",     4)
vdmod_addRegister("C",     1)
vdmod_addRegister("CLOCK", 10)


-- ------------------------------------------------ 
--   構築完了通知                                   
-- ------------------------------------------------ 
function onBuildComplete(clockFreq)
	m_clockFreq = clockFreq
	m_baseClock = clockFreq // m_regClock
end


-- ------------------------------------------------ 
--   破棄通知                                       
-- ------------------------------------------------ 
function onDestroy()
end


-- ------------------------------------------------ 
--   リセット通知                                   
-- ------------------------------------------------ 
function onReset(hard)
	m_breakFlag = m_breakFlag & 2
	m_regPC     = 0
	m_regA      = 0
	m_regB      = 0
	m_regC      = 0

	vdmod_attachClockEvent(1, 1)

	vdmod_writePin(0, 0)
	vdmod_writePin(1, 0)
	vdmod_writePin(2, 0)
	vdmod_writePin(3, 0)
end


-- ------------------------------------------------ 
--   動作開始通知                                   
-- ------------------------------------------------ 
function onStart()
end


-- ------------------------------------------------ 
--   動作停止通知                                   
-- ------------------------------------------------ 
function onStop()
end


-- ------------------------------------------------ 
--   ピン書き込み通知                               
-- ------------------------------------------------ 
function onWritePin(pin, value)
end


-- ------------------------------------------------ 
--   イベント処理                                   
-- ------------------------------------------------ 
function onEventProcess(index)
	-- 命令実行
	opcode  = vdmod_readAddressBus(m_regPC)
	m_regPC = (m_regPC + 1) & 15

	m_inst[opcode>>4](opcode)

	-- 停止処理
	if m_breakFlag ~= 0 then
		if (m_breakFlag & 1) == 1 then		-- ステップイン・アウト
			m_breakFlag = m_breakFlag & ~1
			vdmod_stopClockGen(1)
		elseif m_regPC == m_bkpt then		-- ブレークポイント
			vdmod_stopClockGen(2)
		end
	end

	return m_baseClock
end


-- ------------------------------------------------ 
--   インストラクションアドレス取得通知             
-- ------------------------------------------------ 
function onGetInstAddress()
	return m_regPC
end


-- ------------------------------------------------ 
--   インストラクションアドレス取得通知             
-- ------------------------------------------------ 
function onSetInstAddress(address)
	m_regPC = address & 15
end


-- ------------------------------------------------ 
--   ブレークポイント設定通知                       
-- ------------------------------------------------ 
function onSetBreakpoint(address)
	-- ブレークポイント設定中なら無視
	if (m_breakFlag & 2) == 2 then
		return false
	end

	m_breakFlag = m_breakFlag | 2
	m_bkpt      = address

	return true
end


-- ------------------------------------------------ 
--   ブレークポイント解除通知                       
-- ------------------------------------------------ 
function onDeleteBreakpoint(address)
	-- ブレークポイント解除中なら無視
	if (m_breakFlag & 2) == 0 then
		return false
	end

	m_breakFlag = m_breakFlag & ~2
	m_bkpt      = -1

	return true
end


-- ------------------------------------------------ 
--   ステップイン通知                               
-- ------------------------------------------------ 
function onStepIn()
	m_breakFlag = m_breakFlag | 1
end


-- ------------------------------------------------ 
--   ステップオーバー通知                           
-- ------------------------------------------------ 
function onStepOver()
	m_breakFlag = m_breakFlag | 1
end


-- ------------------------------------------------ 
--   指定アドレスの命令文字列作成通知               
-- ------------------------------------------------ 
function onCreateInstString(address)

	opcode = vdmod_readAddressBus(address&15)
	inst   = opcode >> 4
	str    = string.format("%X  %02X  %s", address, opcode, m_mnemonic[inst])

	type = m_mnemonicType[inst]
	if type == 1 then			-- bit
		str = str .. ((opcode>>3)&1) .. ((opcode>>2)&1) .. ((opcode>>1)&1) .. (opcode&1)
	elseif type == 2 then		-- 4bit
		str = str .. (opcode&15)
	elseif type == 3 then		-- address
		str = str .. string.format("%X", opcode&15)
	elseif type == 4 then		-- 8bit
		str = str .. string.format("%02X", opcode)
	end

	return 1, str
end


-- ------------------------------------------------ 
--   レジスタ取得通知                               
-- ------------------------------------------------ 
function onGetRegister(index)
	if index == 0 then
		return m_regPC
	elseif index == 1 then
		return m_regA
	elseif index == 2 then
		return m_regB
	elseif index == 3 then
		return m_regC
	else
		return m_regClock
	end
end


-- ------------------------------------------------ 
--   レジスタ設定通知                               
-- ------------------------------------------------ 
function onSetRegister(index, value)
	if index == 0 then
		m_regPC = value & 15
	elseif index == 1 then
		m_regA = value & 15
	elseif index == 2 then
		m_regB = value & 15
	elseif index == 3 then
		m_regC = value & 1
	else
		if value < 1 then
			value = 1
		elseif value > 1000 then
			value = 1000
		end

		m_regClock = value
		m_baseClock = m_clockFreq // m_regClock

		vdmod_attachClockEvent(1, m_baseClock)
	end
end


-- ------------------------------------------------ 
--   アドレスバス読み込み通知                       
-- ------------------------------------------------ 
function onReadAddressBus(address)
	return vdmod_readAddressBus(address)
end


-- ------------------------------------------------ 
--   アドレスバス書き込み通知                       
-- ------------------------------------------------ 
function onWriteAddressBus(address, value, size)
	vdmod_writeAddressBus(address, value, size)
end
