﻿#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_Latch.h"

namespace {
bool	ciramA10;
	
int	MAPINT	interceptCHRRead (int bank, int addr) {
	return EMU->ReadCHR(bank + !!ciramA10 *4, addr);
}

int	MAPINT	interceptNTRead (int bank, int addr) {
	if (addr <0x3C0) ciramA10 =!!(bank &(Latch::data &0x40? 2: 1));
	return EMU->ReadCHR(bank, addr);
}

void	sync (void) {
	EMU->SetPRG_RAM8(0x6, 0);
	EMU->SetPRG_ROM32(0x8, Latch::data);
	EMU->SetCHR_RAM8(0x0, 0);
	if (Latch::data &0x40)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
	for (int bank =0; bank <=3; bank++) {
		EMU->SetPPUReadHandler(bank, Latch::data &0x80? interceptCHRRead: EMU->ReadCHR);
		EMU->SetPPUReadHandlerDebug(bank, EMU->ReadCHR);
	}
	for (int bank =8; bank <=11; bank++) {
		EMU->SetPPUReadHandler(bank, Latch::data &0x80? interceptNTRead: EMU->ReadCHR);
		EMU->SetPPUReadHandlerDebug(bank, EMU->ReadCHR);
	}
}


BOOL	MAPINT	load (void) {	
	iNES_SetSRAM();	
	Latch::load(sync, NULL);
	return TRUE;
}

uint16_t mapperNum =514;
} // namespace

MapperInfo MapperInfo_514 = {
	&mapperNum,
	_T("小霸王 卡拉 OK"),
	COMPAT_FULL,
	load,
	Latch::resetHard,
	NULL,
	NULL,
	NULL,
	Latch::saveLoad_D,
	NULL,
	NULL
};