#include	"h_latch.h"

namespace Latch {
uint8_t		data;
uint16_t	addr;
FSync		sync;
FBusConflict	busConflict =NULL;

void	MAPINT	write (int bank, int _addr, int val) {
	data =busConflict? busConflict(val, EMU->GetCPUReadHandler(bank)(bank, _addr)): val;
	addr =bank <<12 |_addr;
	sync();
}

int     busConflictAND (int cpuData, int romData) {
	return cpuData &romData;
}

int     busConflictOR (int cpuData, int romData) {
	return cpuData |romData;
}

int     busConflictROM (int cpuData, int romData) {
	return romData;
}

void	MAPINT	load (FSync _sync, FBusConflict _busConflict) {
	sync =_sync;
	busConflict =_busConflict;
}

void	MAPINT	reset (RESET_TYPE resetType) {
	if (resetType ==RESET_HARD) {
		data =0;
		addr =0;
	}
	sync();
	for (int bank =0x8; bank<=0xF; bank++) EMU->SetCPUWriteHandler(bank, write);
}

void	MAPINT	resetHard (RESET_TYPE resetType) {
	reset(RESET_HARD);
}

int	MAPINT	saveLoad_AD (STATE_TYPE stateMode, int offset, unsigned char *_data) {
	SAVELOAD_WORD(stateMode, offset, _data, addr);
	SAVELOAD_BYTE(stateMode, offset, _data, data);
	if (stateMode ==STATE_LOAD) sync();
	return offset;
}

int	MAPINT	saveLoad_AL (STATE_TYPE stateMode, int offset, unsigned char *_data) {
	SAVELOAD_BYTE(stateMode, offset, _data, addr);
	if (stateMode ==STATE_LOAD) sync();
	return offset;
}

int	MAPINT	saveLoad_A (STATE_TYPE stateMode, int offset, unsigned char *_data) {
	SAVELOAD_WORD(stateMode, offset, _data, addr);
	if (stateMode ==STATE_LOAD) sync();
	return offset;
}

int	MAPINT	saveLoad_D (STATE_TYPE stateMode, int offset, unsigned char *_data) {
	SAVELOAD_BYTE(stateMode, offset, _data, data);
	if (stateMode ==STATE_LOAD) sync();
	return offset;
}

} // namespace Latch