#include "stdafx.h"
#include <stdint.h>
#include "Nintendulator.h"
#include "Settings.h"
#include "resource.h"
#include "Movie.h"
#include "Controllers.h"
#include "MapperInterface.h"
#include "NES.h"
#include "GFX.h"

namespace Controllers
{
#include <pshpack1.h>
struct StdPort_StdController_State
{
	unsigned char Bits;
	unsigned char BitPtr;
	unsigned char Strobe;
	unsigned char NewBits;
};
#include <poppack.h>
int	StdPort_StdController::Save (FILE *out)
{
	int clen = 0;
	unsigned short len = sizeof(*State);

	writeWord(len);
	writeArray(State, len);

	return clen;
}
int	StdPort_StdController::Load (FILE *in, int version_id)
{
	int clen = 0;
	unsigned short len;

	readWord(len);
	readArraySkip(State, len, sizeof(*State));

	return clen;
}
void	StdPort_StdController::Frame (unsigned char mode) {
	int i;
	if (mode & MOV_PLAY)
		State->NewBits = MovData[0];
	else
	{
		State->NewBits = 0;
		for (i = 0; i < 8; i++)
		{
			if (IsPressed(Buttons[i]))
				State->NewBits |= 1 << i;
		}
		if (!EnableOpposites) {	// prevent simultaneously pressing left+right or up+down
			if ((State->NewBits & 0xC0) == 0xC0)
				State->NewBits &= 0x3F;
			if ((State->NewBits & 0x30) == 0x30)
				State->NewBits &= 0xCF;
		}
		if (RI.ConsoleType ==CONSOLE_VT369 && GFX::verticalMode)
			State->NewBits =State->NewBits &0x0F
			              |(State->NewBits &0x10? 0x80: 0x00)
				      |(State->NewBits &0x20? 0x40: 0x00)
				      |(State->NewBits &0x40? 0x10: 0x00)
				      |(State->NewBits &0x80? 0x20: 0x00)
			;
		if (RI.InputType ==INPUT_STANDARD_INVERTED)
			State->NewBits =(State->NewBits &0x51) <<1 | (State->NewBits &0xA2) >>1 | (State->NewBits &0x0C);
		
		if (RI.InputType ==INPUT_DOUBLE_FISTED)
			State->NewBits =State->NewBits &0x0F
			              |(State->NewBits &0x80? 0x10: 0x00)
				      |(State->NewBits &0x40? 0x20: 0x00)
				      |(State->NewBits &0x10? 0x40: 0x00)
				      |(State->NewBits &0x20? 0x80: 0x00)
			;
		
		// Turbo A and B
		if (IsPressed(Buttons[8])) {
			if (GFX::frameCount &2)
				State->NewBits |= 0x01;
			else
				State->NewBits &=~0x01;			
		}
		if (IsPressed(Buttons[9])) {
			if (GFX::frameCount &2)
				State->NewBits |= 0x02;
			else
				State->NewBits &=~0x02;			
		}
	}
	if (mode & MOV_RECORD)
		MovData[0] = State->NewBits;
}
unsigned char	StdPort_StdController::Read (void) {
	unsigned char result;
	if (State->Strobe) {
		State->Bits = State->NewBits;
		State->BitPtr = 0;
		result = (unsigned char)(State->Bits & 1);
	} else {
		if (State->BitPtr <8)
			result = (unsigned char)(State->Bits >> State->BitPtr) &1;
		else
			result = RI.ConsoleType >=5 || NES::CurRegion ==Settings::REGION_DENDY? 0: 1;
		
		if (RI.InputType ==INPUT_PORT_TEST_CONTROLLER) {
			result |=!!(~State->BitPtr &1) *0x18;
			if (State->BitPtr >=8) result |=0x10;
			if (State->BitPtr >=6) result |=0x08;
		}
		
		if (State->BitPtr <8) State->BitPtr++;
	}
	if (RI.InputType ==INPUT_MAGICAL_COOKING) result ^=1;
	return result;
}
void	StdPort_StdController::Write (unsigned char Val) {
	if (State->Strobe || Val & 1) 	{
		State->Strobe = Val & 1;
		State->Bits = State->NewBits;
		State->BitPtr = 0;
	}
}
INT_PTR	CALLBACK	StdPort_StdController_ConfigProc (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam){
	const int dlgLists[10] = {IDC_CONT_D0,IDC_CONT_D1,IDC_CONT_D2,IDC_CONT_D3,IDC_CONT_D4,IDC_CONT_D5,IDC_CONT_D6,IDC_CONT_D7,IDC_CONT_D8,IDC_CONT_D9};
	const int dlgButtons[10] = {IDC_CONT_K0,IDC_CONT_K1,IDC_CONT_K2,IDC_CONT_K3,IDC_CONT_K4,IDC_CONT_K5,IDC_CONT_K6,IDC_CONT_K7,IDC_CONT_K8,IDC_CONT_K9};
	StdPort *Cont;
	if (uMsg == WM_INITDIALOG)
	{
		SetWindowLongPtr(hDlg, GWLP_USERDATA, lParam);
		Cont = (StdPort *)lParam;
	}
	else	Cont = (StdPort *)GetWindowLongPtr(hDlg, GWLP_USERDATA);
	return ParseConfigMessages(hDlg, uMsg, wParam, lParam, 10, 0, dlgLists, dlgButtons, Cont ? Cont->Buttons : NULL, false);
}
void	StdPort_StdController::Config (HWND hWnd) {
	DialogBoxParam(hInst, MAKEINTRESOURCE(IDD_STDPORT_STDCONTROLLER), hWnd, StdPort_StdController_ConfigProc, (LPARAM)this);
}
void	StdPort_StdController::SetMasks (void)
{
}
StdPort_StdController::~StdPort_StdController (void)
{
	delete State;
	delete[] MovData;
}
StdPort_StdController::StdPort_StdController (DWORD *buttons)
{
	Type = STD_STDCONTROLLER;
	NumButtons = 10;
	Buttons = buttons;
	State = new StdPort_StdController_State;
	MovLen = 1;
	MovData = new unsigned char[MovLen];
	ZeroMemory(MovData, MovLen);
	State->Bits = 0;
	State->BitPtr = 0;
	State->Strobe = 0;
	State->NewBits = 0;
}

void StdPort_StdController::CPUCycle (void) { }
} // namespace Controllers