#include	"..\DLL\d_iNES.h"

namespace {
uint8_t	ram[8192];

int	MAPINT	readRAM (int bank, int addr) {
	return ram[bank <<12 |addr];
}

void	MAPINT	writeRAM (int bank, int addr, int val) {
	ram[bank <<12 |addr] =val;
}

int	MAPINT	readReg(int bank, int addr) {
	switch(addr &7) {
	case 0x00:
		return 0xFF;
	case 0x07:
		return 0x02;
	default:
		return 0x50;
	}	
}

void	MAPINT	writeReg (int bank, int addr, int val) {
	;
}


void	MAPINT	reset (RESET_TYPE resetType) {
	for (int bank =0; bank <2; bank++) {
		EMU->SetCPUReadHandler     (bank, readRAM);
		EMU->SetCPUReadHandlerDebug(bank, readRAM);
		EMU->SetCPUWriteHandler    (bank, writeRAM);
	}
	EMU->SetCPUReadHandler (0x5, readReg);
	EMU->SetCPUWriteHandler(0x5, writeReg);
	EMU->SetPRG_RAM8(0x6, 0);
	EMU->SetPRG_ROM32(0x8, 0);
	EMU->SetCHR_ROM8(0x0, 0);
	iNES_SetMirroring();
}

uint16_t mapperNum =752;
} // namespace

MapperInfo MapperInfo_752 ={
	&mapperNum,
	_T("FamicomBox"),
	COMPAT_FULL,
	NULL,
	reset,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};